unit sgen;

interface

uses
    MySysUtl, Windows, Gen, Forms;

{ === Exported declarations === }
function winampGetGeneralPurposePlugin  : PwinampGenMod; cdecl; export;
         {this is the only exported symbol.}
         {returns our main header.}

{ === Configuration declarations === }
const
     config_x  :integer= 50;
     config_y  :integer= 50;
      {screen X position and Y position, respectively}

var
  hMainWnd  :HWND; {main window handle}

procedure Config; cdecl;
function  Init:integer; cdecl;
procedure Quit; cdecl;

{ === Plug-in headers and modules === }
const
{ === Module header: includes version, description, === }
{ === and address of the module retriever function  === }
     HDR  :TWinAMPGenMod =
           (Version      : GEN_HDRVER;
            Description  :'Nullsoft Test General Library v1.0';
            init         : init;
            config       : config;
            quit         : quit;
            hwndParent   : 0;
	    hDllInstance : 0;
           );

implementation

uses unGenForm;

{ === Forward declarations === }
procedure ConfigRead(This_Mod :PWinAMPgenMod); forward;
          {reads the configuration}
procedure ConfigWrite(This_Mod :PWinAMPgenMod); forward;
          {writes the configuration}
procedure ConfigGetINI_FN(This_Mod :PWinAMPgenMod; INIFile :PChar); forward;
          {makes the .ini file filename}

{ === Our routines for ease of use ===}

function  OurMessageBox(Owner :HWND; Msg, Title :string; Style :integer) :integer;
          {Makes a message box with a style of STYLE}
          {MB_OK = OK button}
          {MB_OKCANCEL = OK and Cancel buttons}
          {Returns an ID (0 = ID_OK)}
          begin
          Msg := Msg + #0;
          Title := Title + #0;
          Result := MessageBox(Owner,@Msg[1],@Title[1],Style);
          end;

{ === Visualization plug-in methods === }

function  winampGetGeneralPurposePlugin :PWinAMPGenMod;
          {WinAMP calls this exported function}
          {to get the plug-in header}
begin
  Result := @HDR;  {Return the main header}
end; { winampVisGetHeader }

procedure Config;
          {The configuration method for the given module}
          {Doesn't have to be a single procedure that shares}
          {all the modules.  You can have multiple Configs:}
          {Config1, Config2, Config3, etc.}
begin
  OurMessageBox(HDR.hWNDParent,
                'This module is Copyright(C) 1997, Justin Frankel/Nullsoft'#13+
                'Delphi conversion by Louis Louw - 25/08/2000'#13+
                '-- This is just a demonstration module, it really isn''t'#13+
                '   supposed to be enjoyable --',
                'Configuration: '+HDR.Description,
                MB_OK);
end; { Config }

function  Init:integer;
begin
  ConfigRead(@HDR);  {Read the configuration for the Module}

  IF foGenForm = nil then
   begin
    Application.CreateForm(TfoGenForm,foGenForm);
   end;

  foGenForm.Left := config_x;
  foGenForm.Top  := config_y;

  foGenForm.Remote.DLLmode := True; //Yep - we are in a Winamp DLL!
  foGenForm.Remote.Winamp_Hwnd := HDR.hwndParent; //Set the Winamp window handle - no need to search for it

  foGenForm.Show;

  Result := 0;
end; { Init }


procedure Quit;
          {Cleanup (opposite of Init).}
begin
  config_x := foGenForm.Left;
  config_y := foGenForm.Top;
  
  foGenForm.Free;
  foGenForm := nil;

  ConfigWrite(@HDR);     {write configuration}
end; { Quit }

procedure ConfigGetINI_FN(This_Mod :PWinAMPGenMod; INIFile :PChar);
          {makes an .INI file in the winamp directory}
          {named "plugin.ini"}
          var
             p :PChar;
begin
  GetModuleFileName(This_Mod^.hDLLInstance,INIFile,MAX_PATH);
  p := INIFile + StrLen(INIFile);
  while (p >= INIFile) and (p^ <> '\') do
    dec(p);
  inc(p);
  if p >= INIFile then
    p^ := #0;
  StrCat(INIFile,'plugin.ini');
end; { ConfigGetINI_FN }


procedure ConfigRead(This_Mod :PWinAMPGenMod);
          var
             INIFile : array[0..MAX_PATH-1] of char;
begin
  ConfigGetINI_FN(This_Mod,INIFile);
  config_x := GetPrivateProfileInt(This_Mod^.Description,
                                   'Screen_x',
                                   config_x,
                                   INIFile);
  config_y := GetPrivateProfileInt(This_Mod^.Description,
                                   'Screen_y',
                                   config_y,
                                   INIFile);
end; { ConfigRead }

procedure ConfigWrite(This_Mod :PWinAMPGenMod);
          var
             _string :array[0..31] of char;
             INIFile :array[0..MAX_PATH-1] of char;
begin
  ConfigGetINI_FN(This_Mod,INIFile);
  str(config_x, _string);  {More efficient than StrFmt(...)}
  WritePrivateProfileString(This_Mod^.Description,
                            'Screen_x',
                            _string,
                            INIFile);
  str(config_y, _string);
  WritePrivateProfileString(This_Mod^.Description,
                            'Screen_y',
                            _string,
                            INIFile);
end; { ConfigWrite }

end.
